//
// $Id: padport.cc,v 1.7 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#include "bochs.h"
#if BX_EMULATION_TOWNS
#define LOG_THIS bx_padport.


bx_padport_c bx_padport;
#if BX_USE_PAD_SMF
#define this (&bx_padport)
#endif


bx_padport_c::bx_padport_c(void)
{
}

bx_padport_c::~bx_padport_c(void)
{
  // nothing for now

  delete pads[0];
  delete pads[1];
}


  void
bx_padport_c::init(bx_devices_c *d)
{
  // FM-TOWNS SYSTEM I/O

  BX_PADPORT_THIS devices = d;

  int i;

  static struct {
    Bit16u num;
    Boolean read;
    Boolean write;
  } padport_ports[]={
    {0x04d0,1,0},
    {0x04d2,1,0},
    {0x04d6,0,1},
    {0,0,0}
  };

  i=0;
  while(padport_ports[i].num!=0) {
    if(padport_ports[i].read) {
      BX_PADPORT_THIS devices->register_io_read_handler(this, read_handler,
							 padport_ports[i].num,
							  "pad and mouse interface");
    }
    if(padport_ports[i].write) {
      BX_PADPORT_THIS devices->register_io_write_handler(this, write_handler,
							  padport_ports[i].num,
							  "pad and mouse interface");
    }
    i++;
  }

  BX_PADPORT_THIS pads[0] = new bx_fmmouse_c;
  BX_PADPORT_THIS pads[1] = new bx_nullpad_c;
  BX_PADPORT_THIS pads[0]->init(BX_PADPORT_THIS devices, this, 0);
  BX_PADPORT_THIS pads[1]->init(BX_PADPORT_THIS devices, this, 1);
}
  // static IO port read callback handler
  // redirects to non-static class handler to avoid virtual functions

  Bit32u
bx_padport_c::read_handler(void *this_ptr, Bit32u address, unsigned io_len)
{
#if !BX_USE_PAD_SMF
  bx_padport_c *class_ptr = (bx_padport_c *) this_ptr;

  return( class_ptr->read(address, io_len) );
}

  Bit32u
bx_padport_c::read(Bit32u address, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif
  Bit32u ret;
#define RETURN(x) do { ret = (x); goto read_return; } while (0)

  if (io_len > 1)
    BX_PANIC(("padport: io read from address %08x len=%u\n",
	      (unsigned) address, (unsigned) io_len));

  switch (address) {
    case 0x04d0:
    case 0x04d2:
      RETURN(BX_PADPORT_THIS pads[(address-0x04d0)/2]->read());

    default:
      BX_PANIC(("unsupported padport read, address=0x%.4x!\n",
        (unsigned) address));
      RETURN(0);
      break;
    }
  read_return:
  if (bx_dbg.padport)
    BX_INFO(("PADPORT read from address: 0x%x = 0x%x\n",
      (unsigned) address, (unsigned) ret));
  return ret;
}
#undef RETURN


  // static IO port write callback handler
  // redirects to non-static class handler to avoid virtual functions

  void
bx_padport_c::write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len)
{
#if !BX_USE_PAD_SMF
  bx_padport_c *class_ptr = (bx_padport_c *) this_ptr;

  class_ptr->write(address, value, io_len);
}

  void
bx_padport_c::write(Bit32u address, Bit32u value, unsigned io_len)
{
#else
  UNUSED(this_ptr);
#endif  // !BX_USE_PAD_SMF

  if (io_len > 1)
    BX_PANIC(("padport: io write to address %08x len=%u\n",
	      (unsigned) address, (unsigned) io_len));

  if (bx_dbg.padport)
    BX_INFO(("PADPORT write to address: 0x%x = 0x%x\n",
      (unsigned) address, (unsigned) value));

  switch (address) {
    case 0x04d6:
      BX_PADPORT_THIS pads[0]->write(((value >>2) & 0x04) |
				     ( value      & 0x03));
      BX_PADPORT_THIS pads[1]->write(((value >>3) & 0x04) |
				     ((value >>2) & 0x03));
      return;

    default:
      BX_PANIC(("unsupported padport write, address=0x%.4x!\n",
        (unsigned) address));
      return;
      break;
    }
}
#endif
